
/*
 * Primeiro exerccio do Tutorial de J2ME
 *
 * @author Tarcisio Camara
 */
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

/**
 * Classe principal do jogo. Responsvel pela lgica de pintura, coliso
 * e controle da nave.
 */
public class ShipGameScreen extends Canvas{

    /** Array de balas */
    private Fire[] fires;

    /** Vetor de inimigos */
    private Vector enemies;

    /** Numero de inimigos mortos */
    private int enemiesFired;

    /** Nave do heri */
    private Ship ship;

    /** Pontuao */
    private int countScore;

    /** Nvel corrente */
    private int level;

    /** Nmero de inimigos */
    private int num_enemies;

    /** Tempo que o texto de "Level X"  mostrado na tela */
    private static int textLifeTime = 0;

    /** Indica se deve mostrar o texto de "Level X" */
    private static boolean scrollText = false;

    /** Texto que ser mostrado */
    private static String scrollingText = "";

    /**
     * Construtor
     */
    public ShipGameScreen() {
        // Inicializa variveis de dimenso
        Constants.WIDTH  = getWidth();
        Constants.HEIGHT = getHeight();

        //inicializa variveis e comandos
        this.init();
    }

    /**
     * Inicializao da classe
     */
    public void init() {
        //primeiro nvel
        this.level = 1;

        //carrega as imagens
        Constants.loadImages();

        //carrega os objetos do jogo
        loadShipBullets();
        loadShip();
        loadEnemies();

        //zera os pontos
        this.countScore = 0;

        //adiciona os comandos
        this.addCommand(Constants.pauseCommand);
        this.addCommand(Constants.exitCommand);

        //seta as variaveis de pause e game over pra falso
        ShipController.setGameOver(false);
        ShipController.setPaused(false);
    }

    /**
     * Cria o objeto da nave
     */
    private void loadShip() {
          this.ship = new Ship((getWidth() - Constants.SHIP_FRAME_WIDTH)/2,
                                getHeight() - Constants.SHIP_FRAME_HEIGHT - 5,
                                Constants.flyShipSequence,
                                this.fires);
    }

    /**
     * Crias as balas
     */
    private void loadShipBullets() {
        this.fires = new Fire [Constants.NUM_BULLETS];
        for(int i = 0; i < this.fires.length; i++) {
            this.fires [i] = new Fire(0,0,false,Constants.bulletSequence);
        }
    }


    /**
     * Cria os inimigos de acordo com nvel
     */
    private void loadEnemies() {

        switch(this.level) {
            case 1 :
                this.num_enemies = 3;
                break;
            case 2 :
                this.num_enemies = 4;
                break;
            case 3 :
                this.num_enemies = 5;
                break;
            case 4 :
                this.num_enemies = 6;
                break;
            case 5 :
                this.num_enemies = 7;
                break;
            case 6 :
                this.num_enemies = 8;
                break;
            case 7 :
                this.num_enemies = 9;
                break;
            default :
                this.num_enemies  = 10;
        }

        //Vetor com todos os inimigos
        this.enemies     = new Vector(this.num_enemies);

        //cria cada um dos inimigos em posies X,Y randmicas
        for(int i = 0; i < this.num_enemies; i++) {
            Enemy thisEnemy = new Enemy  (0,0,Constants.flyEnemySequence,true);
            thisEnemy.randomize();
            this.enemies.addElement(thisEnemy);
        }
    }

    /**
     * Atualiza os estados dos objetos do jogo
     */
    public void update() {
        // Atualiza as balas
        for(int i = 0; i < this.fires.length; i++) {
            this.fires [i].update();
        }

        //Atualiza os inimigos
        Enemy enemy;
        for(int i = 0; i < this.enemies.size(); i++) {
            enemy = (Enemy) this.enemies.elementAt(i);
            if(enemy != null) {
                enemy.update();
            }
        }

        //Atualiza a nave
        this.ship.update();
        
        // Tratamento de coliso dos inimigos
        Enemy myEnemy = null;
        int   i       = 0;
        int   j       = 0;

        while(j < this.enemies.size()) {
            // Para cada inimigo
            myEnemy = (Enemy) this.enemies.elementAt(j);

            //Testa coliso com todas as balas
            for(i = 0; i < Constants.NUM_BULLETS; i++) {
                if(this.fires [i].isVisible()) {
                    // caso a bala colida com o inimigo
                    if(this.fires [i].intersects(myEnemy)) {
                        this.enemyFired(myEnemy,this.fires[i]);
                        break;
                    }
                }
            }

            //V se algum inimigo colidiu com a nave
            if(this.ship.intersects(myEnemy)) {
                //caso colida
                this.shipDestroyed(myEnemy);
            }
            j++;
        }
        
        // Testa se foi game over
        if((this.ship.getLife() < 0)) {
            ShipController.setGameOver(true);
        } else {
            // Testa se passou de nvel
            if(this.enemies.size() == 0) {
                //incrementa os nveis
                this.level++;
                //Faz aparecer a mensagem de novo nivel
                startScrolling("Level "+this.level);

                //carrega os inimigos do prximo nvel.
                loadEnemies();
            }
        }
    }

    /**
     * Mtodo responsvel por tratar a coliso das balas com
     * os inimigos.
     * @param enemyFired Inimigo atingido
     * @param bullet Bala que atingiu o inimigo
     */
    private void enemyFired(Enemy enemyFired, Fire bullet){
        //faz o inimigo explodir
        enemyFired.setBlown(true);
        //incrementa o numero de inimigos atingidos
        this.enemiesFired++;
        //incrementa a pontuao
        this.countScore += enemyFired.getScore();
        //faz a bala ficar invisvel
        bullet.setVisible(false);
    }

    /**
     * Mtodo responsvel por tratar a coliso da nave com algum inimigo
     * @param enemy Inimigo que colidiu com a nave
     */
    private void shipDestroyed(Enemy enemy){
        //caso o inimigo ja nao esteja destrudo
        if(!enemy.isBlown()) {
            //diminui uma vida
            this.ship.setLife((short) (this.ship.getLife() - 1));
            //faz a nave explodir
            this.ship.setBlown(true);
            //faz o inimigo tb explodir
            enemy.setBlown(true);
        }
    }

    /**
     * Renderiza os objetos do jogo, as indicaes de vida e pontos
     * Faz todo o tratamento de coliso.
     */
    public void paint(Graphics g) {

        Enemy myEnemy = null;
        int   i       = 0;

        // Limpa toda a tela
        this.cleanAll(g);

        // Pinta as vidas
        this.paintLifes(g);

        //Pinta os pontos
        this.paintScore(g);

        //Desenha, se for o caso, o texto de indicao de level
        this.drawScrollText(g);

        // Desenha os inimigos
        i = 0;
        while(i < this.enemies.size()) {
            myEnemy = (Enemy) this.enemies.elementAt(i);
            if(myEnemy.isVisible()) {
                //caso esteja morto, remove do pool
                if(myEnemy.isDead()) {
                    this.enemies.removeElementAt(i);
                    i--;
                }
                //renderiza cada um dos inimigos
                myEnemy.paint(g);
            }
            i++;
        }

        // Desenhas as balas
        for(i = 0; (enemies.size() != 0) && (i < Constants.NUM_BULLETS);i++) {
            if(this.fires [i].isVisible()) {
                this.fires [i].paint(g);
            }
        }

        // Desenha a nave
        if(this.ship.isVisible()) {
            this.ship.paint(g);
        }

        // Testa se foi game over
        if((this.ship.getLife() < 0)) {
            this.cleanAll(g);

            //Desenha a inrformao de game over na tela
            String texto = "GAME OVER";
            g.setColor(0xffffff);
            g.drawString(texto,
                         (getWidth() - g.getFont().stringWidth(texto))/2,
                         (getHeight() - g.getFont().getHeight())/2,
                         Graphics.TOP | Graphics.LEFT);
        }
    }


    /**
     * Renderiza as imagens que representam as "vidas"
     */
    private void paintLifes(Graphics g) {
        for(int i = 0; i < this.ship.getLife(); i++) {
            g.drawImage(Constants.lifeImage,
                        2 * i + 1 + i * Constants.lifeImage.getWidth(), 1,
                        Graphics.TOP | Graphics.LEFT);
        }
    }

    /**
     * Renderiza a pontuao
     */
    private void paintScore(Graphics g) {

        g.setColor(0xFFFFFF);
        g.setFont(Constants.FONT);
        g.drawString(this.getScore(),
                     Constants.WIDTH - 1, 0, Graphics.TOP | Graphics.RIGHT);
    }

    /**
     * Limpa a tela
     */
    private void cleanAll(Graphics g) {
        g.setColor(0);
        g.fillRect(0, 0, Constants.WIDTH,
                   Constants.HEIGHT);
    }


    /**
     * Habilita um texto ser renderizado na tela e "rolar" at desaparecer
     */
    public void drawScrollText(Graphics g) {

        Font font = Font.getFont(
            Font.FACE_MONOSPACE,
            Font.STYLE_BOLD,
            Font.SIZE_MEDIUM
            );

        g.setFont(font);

        if (textLifeTime > 0) {
            g.setColor(31 - (40-textLifeTime)*(31/40), 136 - (40-textLifeTime)*(56/40), 141 + (40-textLifeTime)*(48/40));
            if (scrollText) {
                int x = (g.getClipWidth()-g.getFont().stringWidth(scrollingText))/2;
                int y = 15 + textLifeTime;
                g.drawString(scrollingText, x, y, Graphics.TOP|Graphics.LEFT);
            } else {
                g.drawString(scrollingText, (g.getClipWidth()-g.getFont().stringWidth(scrollingText))/2,  15, Graphics.TOP|Graphics.LEFT);
            }
            textLifeTime--;
        } else {
            scrollText = false;
        }
    }


   /**
    * Chamado quando uma tecla  pressionada
    *
    * @param keyCode Cdigo da tecla pressionada
    */
    public void keyPressed(int keyCode) {
        //ve qual foi a tecla pressionada
        switch(getGameAction(keyCode)){
          case Canvas.LEFT:
              //indica que a nave vai pra esquerda
              this.ship.left = true;
              break;
          case Canvas.RIGHT:
              //indica que a nave vai pra direita
              this.ship.right = true;
              break;
          case Canvas.FIRE:
              //atira
              this.ship.fire();
              break;
        }
    }

   /**
    * Chamado quando uma tecla  liberada
    *
    * @param keyCode Cdigo da tecla liberada
    */
   public void keyReleased(int keyCode){
        switch(getGameAction(keyCode)){
          case Canvas.LEFT:
              //indica que a nave parou
              this.ship.left = false;
              break;
          case Canvas.RIGHT:
              //indica que a nave parou
              this.ship.right = false;
              break;
         }
   }

    /**
     * Habilita um texto ser renderizado na tela e "rolar" at desaparecer
     *
     * @param s Texto a ser renderizado
     */
    public static void startScrolling(String s) {
        textLifeTime = 40;
        scrollText = true;
        scrollingText = s;
    }

    public String getScore() {
        return String.valueOf(countScore);
    }
}
